import { DB_FILENAME } from "$lib/config";
import sqlite3 from "sqlite3";
import { open } from "sqlite";
import slugify from "slugify";

export const get = async (request) => {
    const db = await open({
    filename: DB_FILENAME,
    driver: sqlite3.Database,
  });

  const sql = "SELECT * FROM post WHERE active = :active AND slug = :slug";
  const result = await db.all(sql, { ":active": 1, ":slug" : request.params.slug });

  const post = (result.length > 0) ? result[0] : null;

  return {
    body: { status: true, post },
  };
};

export const put = async (request) => {
  const data = JSON.parse(request.body);
  const db = await open({
    filename: DB_FILENAME,
    driver: sqlite3.Database,
  });

  const query =
    "UPDATE post SET body = :body WHERE id = :id";
  const params = {
    ":id": data.id,
    ":body": data.body,
  };

  const result = await db.run(query, params);

  console.log(result)

  const sql = "SELECT * FROM post WHERE id = :id ";
  const posts = await db.all(sql, { ":id": data.id });

  const post = (posts.length > 0) ? posts[0] : null;

  if (result.changes) {
    return {
      body: { status: true, post },
    };
  } else {
    return {
      body: { status: false, post },
    };
  }
};